/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockPropertyChangeEvent;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.WipingRelayPECParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class WipingRelayPECBlock
extends SpecialBlock {
    static final long serialVersionUID = -2851829847442736964L;
    private int serializedDataVersion = 2;
    private transient WipingRelayPECParameter fParameter;
    private InBlockConnector[][] fInConnectorsSet;

    public WipingRelayPECBlock() {
    }

    public WipingRelayPECBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected boolean calculateBinaryValue() {
        boolean reset = false;
        boolean trigger = ((BinaryInBlockConnector)this.fInConnectors[0]).calculateBinaryValue();
        if (this.fInConnectors.length > 2) {
            reset = ((BinaryInBlockConnector)this.fInConnectors[1]).calculateBinaryValue();
        }
        boolean result = this.getParameter().getValue(trigger, reset);
        return result;
    }

    protected int getDefaultOrder() {
        return 800;
    }

    public final int getOpcode() {
        return 51;
    }

    protected void initInConnectors() {
        BinaryInBlockConnector triggerConnector = new BinaryInBlockConnector(this, false, "Trg");
        BinaryInBlockConnector resetConnector = new BinaryInBlockConnector(this, false, "R");
        ParameterInBlockConnector parameterConnector = new ParameterInBlockConnector((Block)this, "DE.siemens.ad.logo.model.WipingRelayPECParameter", "Par");
        this.fParameter = (WipingRelayPECParameter)parameterConnector.getLinkedParameter();
        this.setInConnectorSet(triggerConnector, resetConnector, parameterConnector);
        this.setCorrectInConnectors();
    }

    protected void setCorrectInConnectors() {
        Hardware hw;
        boolean supportResetConnector = true;
        if (this.fWiringDiagram != null && (hw = this.fWiringDiagram.getHardware()) != null) {
            supportResetConnector = hw.supports("wipingPecR");
        }
        this.fInConnectors = supportResetConnector ? this.fInConnectorsSet[1] : this.fInConnectorsSet[0];
    }

    public void write(StorableOutput dw) {
        int i;
        super.write(dw);
        dw.writeStorable(this.fParameter);
        if (this.fInConnectors != null) {
            dw.writeInt(this.fInConnectors.length);
            for (i = 0; i < this.fInConnectors.length; ++i) {
                dw.writeStorable(this.fInConnectors[i]);
            }
        } else {
            dw.writeInt(0);
        }
        for (i = 0; i < this.fInConnectorsSet.length; ++i) {
            for (int j = 0; j < this.fInConnectorsSet[i].length; ++j) {
                dw.writeStorable(this.fInConnectorsSet[i][j]);
            }
        }
    }

    public void read(StorableInput dr) throws IOException {
        int i;
        super.read(dr);
        this.fParameter = (WipingRelayPECParameter)dr.readStorable();
        int count = dr.readInt();
        if (count > 0) {
            this.fInConnectors = new InBlockConnector[count];
            for (i = 0; i < count; ++i) {
                this.fInConnectors[i] = (InBlockConnector)dr.readStorable();
            }
        }
        for (i = 0; i < this.fInConnectorsSet.length; ++i) {
            for (int j = 0; j < this.fInConnectorsSet[i].length; ++j) {
                this.fInConnectorsSet[i][j] = (InBlockConnector)dr.readStorable();
            }
        }
    }

    protected void setInConnectorSet(InBlockConnector triggerConnector, InBlockConnector resetConnector, ParameterInBlockConnector parameterConnector) {
        this.fInConnectorsSet = new InBlockConnector[2][];
        this.fInConnectorsSet[0] = new InBlockConnector[2];
        this.fInConnectorsSet[0][0] = triggerConnector;
        this.fInConnectorsSet[0][1] = parameterConnector;
        this.fInConnectorsSet[1] = new InBlockConnector[3];
        this.fInConnectorsSet[1][0] = triggerConnector;
        this.fInConnectorsSet[1][1] = resetConnector;
        this.fInConnectorsSet[1][2] = parameterConnector;
        this.fInConnectors = this.fInConnectorsSet[1];
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean result = super.isAvailable(hw, errorList);
        if (this.isResetInputNeeded() && !hw.supports("comfortSwitchResetWarning")) {
            errorList.add(new ErrorInfo(this, "error.convert.comfortSwitch.resetUsed", hw));
            result &= false;
        }
        return result;
    }

    public boolean isResetInputNeeded() {
        if (!(this.getInConnectorCount() > 2)) {
            return false;
        }
        InBlockConnector resetConnector = this.getInConnector(1);
        if (resetConnector.getLinkedConnectorsCount() > 0) {
            return true;
        }
        return resetConnector.isNegated();
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        this.setTimerRemanence((Hardware)hardwareChangedEvent.getNewValue());
        this.fToolTipText = null;
        int connectorCount = this.getInConnectorCount();
        this.setCorrectInConnectors();
        if (connectorCount != this.getInConnectorCount()) {
            this.fireBlockPropertyChangeEvent(new BlockPropertyChangeEvent(this, "inConnector"));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.serializedDataVersion < 2) {
            this.serializedDataVersion = 2;
            InBlockConnector triggerConnector = this.getInConnector(0);
            ParameterInBlockConnector parameterConnector = (ParameterInBlockConnector)this.getInConnector(1);
            BinaryInBlockConnector resetConnector = new BinaryInBlockConnector(this, false, "R");
            this.setInConnectorSet(triggerConnector, resetConnector, parameterConnector);
            this.setCorrectInConnectors();
        }
    }
}

